<?php $__env->startSection('title','CARRISOFT V2: BON DE COMMANDE'); ?>

<?php $__env->startSection('extra-meta'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;margin-bottom: 20px">
        <h3 class="ml-5"><?php echo e(__('messages.GESTION DES COMMANDES')); ?></h3>
        <div class="col-12 col-sm-12 col-md-12">
            <div class="col-12 col-md-7 float-left">
                <h3><i class="fa fa-plus"></i><?php echo e(__('messages.Preparation Commande')); ?></h3>
            </div>
            <div class="col-12 col-sm-5 col-md-5 float-right">
                <a href="<?php echo e(route('cmde.histo')); ?>" class="btn btn-danger"><i class="fa fa-info"></i><?php echo e(__('messages.Historique des Commandes')); ?></a>
            </div>
        </div>
        <br><br>
        <div class="col-md-12 float-left">
            <div class="col-md-7 float-left">
                <h5 class="ml-5"><?php echo e(__('messages.PRODUITS SELECTIONNES')); ?></h5>
            </div>
            <div class="col-md-5 float-right">
                <h5 class="inline"> <?php echo e(__('messages.LISTE DES PRODUITS')); ?></h5>
                <button type="button" name="create_pdt" id="create_pdt" class="btn btn-success inline"><i class="fa fa-plus"></i> <?php echo e(__('messages.Nouveau Produit')); ?></button>
            </div>
        </div>
        <br><br>
        <div class="col-md-12 float-left">
            <div class="col-md-7 float-left">
                <div class="contour_div">
                    <div class="contour_table">
                        <table class="table table-striped table-bordered contour_table" id="pdt_selected">

                        </table>
                    </div>
                    <div class="info-box">
                        <?php echo $__env->make('commande/form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>

            </div>

            <div class="col-md-5 float-right">
                <div class="info-box">
                    <div class="table-responsive div_style">
                        <table id="liste_produit" class="display table table-striped table-bordered data-table">
                            <thead>
                            <tr>
                                <th><?php echo e(__('messages.Libelle')); ?></th>
                                <th><?php echo e(__('messages.Prix achat')); ?></th>
                            </tr>
                            </thead>
                        </table>
                    </div>

                    <!--Ajouter un produit -->
                    <div id="addModal" class="modal fade" role="dialog">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title"><?php echo e(__('messages.Ajouter un produit')); ?></h4>
                                </div>
                                <div class="modal-body">
                                    <span class="form_result" id="form_result">test</span>
                                    <form method="post" id="add_form" class="form-horizontal">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <table width="100%">
                                                <tr>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Libelle')); ?> </label>
                                                        <input type="text" name="nom_commercial" id="nom_commercial" class="form-control" readonly/>
                                                    </td>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Prix achat')); ?> </label>
                                                        <input type="text" name=prix_achat id=prix_achat class="form-control" value="0" required="required"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.CMM')); ?> </label>
                                                        <input type="text" name="cmm" id="cmm" class="form-control" readonly/>
                                                    </td>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.CMM a commander')); ?> </label>
                                                        <input type="numeric" name=cmm_acmde id=cmm_acmde class="form-control" value="2" required="required"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Quantite theorique a commander')); ?>: </label>
                                                        <input type="text" name="qte_theo_acmde" id="qte_theo_acmde" class="form-control" required="required" value="0"/>
                                                    </td>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Quantite a commander')); ?> </label>
                                                        <input type="text" name=qte id=qte class="form-control" value="0" required="required"/>
                                                    </td>
                                                </tr>
                                            </table>

                                        </div>
                                        <div class="form-group" align="center">
                                            <input type="hidden" name="produit_id" id="produit_id" />
                                            <input type="hidden" name="hidden_idcon" id="hidden_idcon" />
                                            <input type="hidden" name="hidden_code" id="hidden_code" />
                                            <input type="submit" name="action_button" id="action_button" class="btn btn-success" value="<?php echo e(__('messages.Ajouter')); ?>" />
                                            <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-windows-close"></i><?php echo e(__('messages.Annuler')); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--Creer un nouveau produit -->
                    <div id="produitModal" class="modal fade" role="dialog">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title"><?php echo e(__('messages.Creer un nouveau produit')); ?></h4>
                                </div>
                                <div class="modal-body">
                                    <span id="formresult"></span>
                                    <form method="post" id="pdtform" class="form-horizontal">
                                        <?php echo csrf_field(); ?>
                                        <table class="responsive-table table">
                                            <tr>
                                                <td>
                                                    <div class="form-group">
                                                        <label class="control-label col-md-12" ><?php echo e(__('messages.Reference Produit')); ?> </label>
                                                        <input type="text" name="PDTreference" id="pdtreference" class="form-control"/>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="form-group">
                                                        <label class="control-label col-md-12" ><?php echo e(__('messages.Libelle Produit')); ?> : </label>
                                                        <input type="text" name="pdtnom_commercial" id="pdtnom_commercial" class="form-control" required="required"/>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="form-group">
                                                        <label class="control-label col-md-12" ><?php echo e(__('messages.Famille therapeutique')); ?> : </label>
                                                        <input type="text" name="pdtfamille_therapeutique" id="pdtfamille_therapeutique" class="form-control"/>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="form-group">
                                                        <label class="control-label col-md-12" ><?php echo e(__('messages.DCI')); ?> : </label>
                                                        <input type="text" name="pdtdci" id="pdtdci" class="form-control" required="required"/>
                                                    </div>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <div class="form-group">
                                                        <label class="control-label col-md-12" ><?php echo e(__('messages.Prix achat')); ?> :</label>
                                                        <input type="text" name="pdtprix_achat" id="pdtprix_achat" class="form-control"/>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="form-group">
                                                        <label class="control-label col-md-12" ><?php echo e(__('messages.Prix de vente')); ?> :</label>
                                                        <input type="text" name="pdtprix_vente" id="pdtprix_vente" class="form-control" required="required"/>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="form-group">
                                                        <label class="control-label col-md-12" ><?php echo e(__('messages.Stock minimum')); ?> :</label>
                                                        <input type="text" name="pdtstock_minimal" id="pdtstock_minimal" class="form-control"/>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="form-group" id="pv_group">
                                                        <label class="control-label col-md-12" ><?php echo e(__('messages.Stock maximum')); ?> : </label>
                                                        <input type="text" name="pdtstock_maximal" id="pdtstock_maximal" class="form-control"/>
                                                    </div>
                                                </td>
                                        </tr>

                                            <tr>
                                                <td>
                                                    <div class="form-group">
                                                        <label class="control-label col-md-12" ><?php echo e(__('messages.Type de produit')); ?> :</label>
                                                        <select name="pdttype" id="pdttype" class="form-control">
                                                            <option id="Perisable" value="Perisable"><?php echo e(__('messages.Selectionner un type')); ?></option>
                                                            <option id="Non_Perisable" value="Non_Perissable"><?php echo e(__('messages.Nom_Perissable')); ?></option>
                                                            <option id="Perisable" value="Perissable"><?php echo e(__('messages.Perissable')); ?></option>
                                                        </select>
                                                    </div>
                                                </td>
                                                <td>
                                                <div class="form-group">
                                                        <?php echo Form::label(__('messages.Selectionner la categorie')); ?>

                                                        <?php echo Form::select('categorieid',$categories,null,['class'=>'form-control','id'=>'categorieid','onchange'=>'verifType()']); ?>

                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="form-group" align="center">
                                                        <input type="hidden" name="produitid" id="produitid" />
                                                        <input type="submit" name="action_button" id="action_button" class="btn btn-success" value="<?php echo e(__('messages.Enregistrer')); ?>" />
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="form-group" align="center">
                                                        <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-windows-close"></i><?php echo e(__('messages.Quitter')); ?></button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--Annuler toute la commande -->
                    <main id="confirmModal" class="modal fade" role="dialog">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="modal-title"><?php echo e(__('messages.Confirmation')); ?></h2>
                                </div>
                                <div class="modal-body">
                                    <h5 align="center" style="margin:0;"><?php echo e(__('messages.annuler produits commande')); ?></h5>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" name="ok_button" id="ok_button" class="btn btn-danger"><?php echo e(__('messages.Oui')); ?></button>
                                    <button type="button" class="btn btn-primary" data-dismiss="modal"><?php echo e(__('messages.Annuler')); ?></button>
                                </div>
                            </div>
                        </div>
                    </main>
                    <!--Infos ajout Produit -->
                    <main id="infoModal" class="modal fade" role="dialog">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="modal-title"><?php echo e(__('messages.Infos')); ?></h2>
                                </div>
                                <div class="modal-body alert alert-warning">
                                    <h5 align="center" style="margin:0;"><?php echo e(__('messages.Vous avez deja selectionner ce produit')); ?></h5>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger violet" data-dismiss="modal"><?php echo e(__('messages.Ok')); ?></button>
                                </div>
                            </div>
                        </div>
                    </main>

                </div>
            </div>
        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        function actualiser() {
            code = document.getElementById("code").value;
            $('#pdt_selected').load('cmde.rech_pdtcon/'+code);
            $("div.dataTables_filter input").focus();
        }

        function fournisseur() {
            $.ajax({
                url:"cmde.fournisseurs",
                dataType:"json",
                success:function(data)
                {
                    $('#fournisseur_id').empty();
                    $('#fournisseur_id').append('<option id=0  value=0>- <?php echo e(__('messages.Choisir un fournisseur')); ?> -</option>');
                    for (var i = 0; i < data.length; i++) {
                        $('#fournisseur_id').append('<option id=' + data[i].fournisseur_id + ' value=' + data[i].fournisseur_id + '>' + data[i].nom +' - '+ data[i].adresse+'</option>');
                    }
                    $('#fournisseur_id').change();
                }
            })
        }

        function rech_mont() {
            code = document.getElementById("code").value;
            $.ajax({
                url:"cmde.rech_mont/"+code,
                dataType:"json",
                success:function(data)
                {
                    document.getElementById("montant").value=data;
                }
            })
        }
        $(document).ready(function(){
            var html = '';
            rech_mont();
            fournisseur();
            actualiser();
            $('#liste_produit').DataTable({
                processing: true,
                serverSide: true,
                ajax:{
                    url: "<?php echo e(route('pdt.index')); ?>",
                },
                columns:[
                    {
                        data: 'nom_commercial',
                        name: 'nom_commercial',
                        render:function (data, type, row) {
                            return "<a href='#' id='"+row.produit_id+"' class='select'>"+row.nom_commercial+"</a>"}
                    },
                    {
                        data: 'prix_achat',
                        name: 'prix_achat'
                    }
                ]
            });

            $("div.dataTables_filter input").focus();

            $('#add_form').on('submit', function(event){
                event.preventDefault();
                var code = document.getElementById('code').value;
                console.log(code);
                $.ajax({
                    url:"<?php echo e(route('cmde.add')); ?>",
                    method:"POST",
                    data: new FormData(this),
                    contentType: false,
                    cache:false,
                    processData: false,
                    dataType:"json",
                    success:function(data)
                    {
                        var html = '';
                        if(data.errors)
                        {
                            html = '<div class="alert alert-danger">';
                            for(var count = 0; count < data.errors.length; count++)
                            {
                                html += '<p>' + data.errors[count] + '</p>';
                            }
                            html += '</div>';
                        }
                        if(data.error)
                        {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if(data.success)
                        {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                            rech_mont();
                            $('#add_form')[0].reset();
                            $('#addModal').modal('hide');
                            $('#pdt_selected').load('cmde.rech_pdtcon/'+code);
                            $("div.dataTables_filter input").val('');
                            $("div.dataTables_filter input").focus();
                        }
                        $('#form_result').html(html);
                    }
                })
            });

            $('#create_pdt').click(function(){
                $('.modal-title').text("Creer un Produit");
                $('#actionbutton').val("Ajouter");
                $('#formresult').val("");
                $('#pdtref').val("");
                $('#pdtlib').val("");
                $('#pdtpv').val("");
                $('#pdtmin').val("");
                $('#pdtmax').val("");
                $('#pdttype').val("Perissable");
                $('#produitModal').modal('show');
            });

            $('#pdtform').on('submit', function(event){
                console.log('Creer un produit')
                event.preventDefault();
                $.ajax({
                    url:"<?php echo e(route('pdt.storenp')); ?>",
                    method:"POST",
                    data: new FormData(this),
                    contentType: false,
                    cache:false,
                    processData: false,
                    dataType:"json",
                    success:function(data)
                    {
                        
                        if(data.errors)
                        {
                            html = '<div class="alert alert-danger">';
                            for(var count = 0; count < data.errors.length; count++)
                            {
                                html += '<p>' + data.errors[count] + '</p>';
                            }
                            html += '</div>';
                        }
                        if(data.error)
                        {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }

                        if(data.success)
                        {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                            $('#pdtform')[0].reset();
                            $('#produitModal').modal('hide');
                            $('#liste_produit').DataTable().ajax.reload();
                        }

                        $('#formresult').html(html);
                    }
                })
            });

            $(document).on('click', '.editer', function(){
                var id = $(this).attr('id');
                var code = document.getElementById('code').value;
                document.getElementById('hidden_code').value = code;

                $('#form_result').html('');
                $.ajax({
                    url:"cmde.select_edit/"+id,
                    dataType:"json",
                    success:function(data){
                        $('#nom_commercial').val(data.libelle);
                        $('#produit_id').val(data.produit_id);
                        $('#hidden_code').val(code);
                        $('#hidden_idcon').val(data.produit_commande_id);
                        $('#qte').val(data.qte);
                        $('#cmm').val(data.cmm);
                        $('#cmm_acmde').val(data.cmm_acmde);
                        $('#qte_theo_acmde').val(data.qte_theo_acmde);
                        $('#prix_achat').val(data.prix_achat);
                        $('#action_button').val("Valider");
                        $('#form_result').html("");
                        if(data.rupture>0){
                           var html = '<div class="alert alert-warning">Ce produit a connu une rupture de ' + data.rupture + ' jour(s). Une CMJ de ' + data.qte_rupture + ' va s ajouter a la quantite theorique a commamder</div>';
                            $('#form_result').html(html);
                        }
                       $('#addModal').modal('show');
                        setTimeout(function() {$('#qte').focus();}, 200);
                    }
                })
            });

            $(document).on('click', '.select', function(){
                var id = $(this).attr('id');
                var code = document.getElementById('code').value;
                document.getElementById('hidden_code').value = code;

                $('#form_result').html('');
                $.ajax({
                    url:"cmde.select/"+id,
                    dataType:"json",
                    success:function(data){
                        if(data.statut=='success'){
                            $('#nom_commercial').val(data.produit.nom_commercial);
                            $('#produit_id').val(data.produit.produit_id);
                            $('#qte').val('');
                            $('#prix_achat').val(data.produit.prix_achat);
                            $('#cmm').val(data.donnees.cmm);
                            $('#cmm_acmde').val('2');
                            $('#qte_theo_acmde').val(data.donnees.qte_theo_acmde);
                            $('#qte').val(data.donnees.qte_theo_acmde);
                            $('#hidden_code').val(code);
                            $('#hidden_idcon').val("");
                            $('#action_button').val("Ajouter");
                            $('#form_result').html("");
                            if(data.donnees.rupture>0){
                            var html = '<div class="alert alert-warning">Ce produit a connu une rupture de ' + data.rupture + ' jour(s). Une CMJ de ' + data.donnees.qte_rupture + ' va s ajouter a la quantite theorique a commamder</div>';
                                $('#form_result').html(html);
                            }
                            $('#addModal').modal('show');
                            setTimeout(function() {$('#qte').focus();}, 200);
                        }else{
                            $('#infoModal').modal('show');
                        }
                        
                    }
                })
            });


            $(document).on('click', '.delete', function(){
                id = $(this).attr('id');
                code = document.getElementById('code').value;
                $.ajax({
                    url:"cmde.delete/"+id,
                    success:function(data)
                    {
                        setTimeout(function(){
                            $('#confirmModal').modal('hide');
                            $('#liste_client').DataTable().ajax.reload();
                        }, 100);

                        rech_mont();
                        $('#pdt_selected').load('cmde.rech_pdtcon/'+code);
                        $("div.dataTables_filter input").focus();
                    }
                })
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/commande/index.blade.php ENDPATH**/ ?>